
<?php $__env->startSection('title', $title); ?>

<?php $__env->startSection('content'); ?>
<!-- Breadcrumbs + Page Title -->
<div class="mb-6">
    <div class="flex items-center justify-between">
        <!-- Action Buttons -->
        <div class="flex space-x-3">
            <form action="<?php echo e(route('notifications.read.all')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <button type="submit" class="inline-flex items-center px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary-500">
                    <i data-lucide="check-circle" class="h-4 w-4 mr-2"></i> Mark All as Read
                </button>
            </form>
            <form action="<?php echo e(route('notifications.destroy.all')); ?>" method="POST" onsubmit="return confirm('Are you sure you want to delete all notifications?')">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button type="submit" class="inline-flex items-center px-4 py-2 border border-red-300 rounded-md shadow-sm text-sm font-medium text-red-700 bg-white hover:bg-red-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                    <i data-lucide="trash-2" class="h-4 w-4 mr-2"></i> Delete All
                </button>
            </form>
        </div>
    </div>
</div>

<!-- Alerts -->
<?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.danger-alert','data' => []]); ?>
<?php $component->withName('danger-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
<?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.success-alert','data' => []]); ?>
<?php $component->withName('success-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
<?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.error-alert','data' => []]); ?>
<?php $component->withName('error-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>

<!-- Notifications List -->
<div class="bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden mb-8">
    <div class="border-b border-gray-200 px-6 py-4">
        <h3 class="text-lg font-medium text-gray-900">All Notifications</h3>
    </div>

    <?php if(count($notifications) > 0): ?>
        <div class="divide-y divide-gray-200">
            <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="p-6 hover:bg-gray-50 transition <?php echo e($notification->is_read ? 'opacity-70' : ''); ?>">
                    <div class="flex">
                        <div class="flex-shrink-0">
                            <div class="flex items-center justify-center h-12 w-12 rounded-full 
                                <?php if($notification->type == 'success'): ?> bg-green-100 text-green-500 
                                <?php elseif($notification->type == 'warning'): ?> bg-yellow-100 text-yellow-500 
                                <?php elseif($notification->type == 'danger'): ?> bg-red-100 text-red-500 
                                <?php else: ?> bg-blue-100 text-blue-500 <?php endif; ?>"
                            >
                                <i data-lucide="<?php echo e($notification->icon ?? 'bell'); ?>" class="h-6 w-6"></i>
                            </div>
                        </div>
                        <div class="ml-4 flex-1">
                            <div class="flex items-center justify-between">
                                <div>
                                    <?php if($notification->title): ?>
                                        <h4 class="text-base font-medium text-gray-900"><?php echo e($notification->title); ?></h4>
                                    <?php endif; ?>
                                    <p class="text-sm text-gray-600 mt-1"><?php echo e($notification->message); ?></p>
                                    <p class="text-xs text-gray-500 mt-2"><?php echo e($notification->created_at->format('M d, Y')); ?> at <?php echo e($notification->created_at->format('h:i A')); ?></p>
                                </div>
                                <div class="flex space-x-2">
                                    <?php if(!$notification->is_read): ?>
                                        <a href="<?php echo e(route('notifications.read', $notification->id)); ?>" class="inline-flex items-center px-3 py-1 border border-gray-300 rounded-md shadow-sm text-xs font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary-500">
                                            <i data-lucide="check" class="h-3 w-3 mr-1"></i> Read
                                        </a>
                                    <?php endif; ?>
                                    <form action="<?php echo e(route('notifications.destroy', $notification->id)); ?>" method="POST" onsubmit="return confirm('Are you sure you want to delete this notification?')">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="inline-flex items-center px-3 py-1 border border-red-300 rounded-md shadow-sm text-xs font-medium text-red-700 bg-white hover:bg-red-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                                            <i data-lucide="trash" class="h-3 w-3 mr-1"></i> Delete
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        
        <!-- Pagination -->
        <div class="px-6 py-4 border-t border-gray-200">
            <?php echo e($notifications->links()); ?>

        </div>
    <?php else: ?>
        <div class="py-12 flex flex-col items-center justify-center text-center px-6">
            <div class="bg-gray-50 rounded-full p-3 mb-4">
                <i data-lucide="inbox" class="h-8 w-8 text-gray-400"></i>
            </div>
            <h3 class="text-lg font-medium text-gray-900">No Notifications</h3>
            <p class="text-gray-500 text-sm mt-2 max-w-md">
                You don't have any notifications yet. Notifications will appear here when there are updates related to your account.
            </p>
        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('layouts.dash2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/globalch/public_html/resources/views/user/notifications/index.blade.php ENDPATH**/ ?>