<?php
    if ($settings->redirect_url != null or !empty($settings->redirect_url)) {
        header("Location: $settings->redirect_url", true, 301);
        exit();
    }
?>

<?php $content = app('App\Http\Controllers\FrontController'); ?>
<?php $__env->startSection('title', 'About Us'); ?>


<?php $__env->startSection('content'); ?>


<!-- START SECTION BANNER -->
<section class="hero-section ptb-100 gradient-overlay" style="background: url('https://images.unsplash.com/photo-1501167786227-4cba60f6d58f?ixlib=rb-4.0.3&amp;ixid=MnwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8&amp;auto=format&amp;fit=crop&amp;w=2070&amp;q=80')no-repeat center center / cover">
    <div class="container">


        <div class="row justify-content-center">
            <div class="col-md-8 col-lg-7">
                <div class="page-header-content text-white text-center pt-sm-5 pt-md-5 pt-lg-0">
                    <h1 class="text-white mb-0">About Us</h1>
                    <div class="custom-breadcrumb">
                        <ol class="breadcrumb d-inline-block bg-transparent list-inline py-0">
                            <li class="list-inline-item breadcrumb-item active"><?php echo e($settings->site_name); ?></li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="promo-section pt-100">
    <div class="container">
        <div class="row">
            <div class="col-md-4 col-lg-4">
                <div class="single-promo-block p-3 rounded d-flex justify-content-between">
                    <div class="promo-block-icon mr-4">
                        <span class="fas fa-life-ring icon-md color-primary"></span>
                    </div>
                    <div class="promo-block-content">
                        <h5>STABLE BANKING</h5>
                        <p>We provide services void of errors and irregularities while maintaining consistency in quality of service</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4 col-lg-4">
                <div class="single-promo-block p-3 rounded d-flex justify-content-between">
                    <div class="promo-block-icon mr-4">
                        <span class="fas fa-bezier-curve icon-md color-primary"></span>
                    </div>
                    <div class="promo-block-content">
                        <h5>RELIABLE SYSTEM</h5>
                        <p>Our system has been made reliable by making our services available and accessible anytime from anywhere </p>
                    </div>
                </div>
            </div>
            <div class="col-md-4 col-lg-4">
                <div class="single-promo-block p-3 rounded d-flex justify-content-between">
                    <div class="promo-block-icon mr-4">
                        <span class="fas fa-lock icon-md color-primary"></span>
                    </div>
                    <div class="promo-block-content">
                        <h5>FULLY SECURED</h5>
                        <p>We use updated and sophisticated fintech technologies to secure and ensure safe transactions for all users</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4 col-lg-4">
                <div class="single-promo-block p-3 rounded d-flex justify-content-between">
                    <div class="promo-block-icon mr-4">
                        <span class="fa fa-university icon-md color-primary"></span>
                    </div>
                    <div class="promo-block-content">
                        <h5>LOAN</h5>
                        <p>We offer different kinds of loans Students Loan, Business banking and more.</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4 col-lg-4">
                <div class="single-promo-block p-3 rounded d-flex justify-content-between">
                    <div class="promo-block-icon mr-4">
                        <span class="fa fa-headphones icon-md color-primary"></span>
                    </div>
                    <div class="promo-block-content">
                        <h5>RELIABLE CUSTOMER SERVICE</h5>
                        <p>Get help in seconds Contact Customer Support We're available to help you 24 hours a day, 7 days a week.</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4 col-lg-4">
                <div class="single-promo-block p-3 rounded d-flex justify-content-between">
                    <div class="promo-block-icon mr-4">
                        <span class="fa fa-wallet icon-md color-primary"></span>
                    </div>
                    <div class="promo-block-content">
                        <h5>PERSONAL SAVINGS</h5>
                        <p>Savings account offered by banks that gives you a safe place to store your money and often earns compounding interest.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="about-us-section ptb-100">
    <div class="container">
        <div class="row justify-content-around">
            <div class="col-md-12 col-lg-6">
                <div class="about-img-wrap">
                    <img src="temp/custom/img/bg3.jpg" alt="video" class="img-fluid rounded shadow-sm">

                </div>
            </div>
            <div class="col-md-12 col-lg-5">
                <div class="about-content-right mb-md-4 mb-lg-0">
                    <h2>About Us</h2>
                    <p>A few years ago, a small team of people determined to transform banking launched a savings app for everyone. That app was the first step toward <?php echo e($settings->site_name); ?> Bank.
                    Today, we’re even more determined and we’ve built a Central Bank-licensed, microfinance bank to help you get the best out of your money without overcharging you.
                    <?php echo e($settings->site_name); ?> includes tools for tracking your spending habits, saving more and making the right money moves.
                    So no matter who you are or where you live, we’re here because of you. We know the pain that comes with using a regular bank and we will make things work better for everyone.
                    </p>
                    <div class="action-btns mt-3">
                        <a href="about" class="btn btn-primary">Read More</a>
                    </div>

                    <div class="feature-tabs-wrap">
                        <ul class="nav nav-tabs mb-3 border-bottom-0 feature-tabs" data-tabs="tabs">
                            <li class="nav-item">
                                <a class="nav-link d-flex align-items-center active" href="#feature-tab-2"
                                    data-toggle="tab">
                                    <h6 class="mb-0">Our Mission</h6>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link d-flex align-items-center" href="#feature-tab-3"
                                    data-toggle="tab">
                                    <h6 class="mb-0">Our Vision</h6>
                                </a>
                            </li>
                        </ul>
                        <div class="tab-content feature-tab-content">
                            <div class="tab-pane active" id="feature-tab-2">
                                <p>The goal of <?php echo e($settings->site_name); ?> Bank is to provide its users a unique, safe and secured platform for
                                    transactions in the field of finance and fintech. This is why we have used
                                    cutting-edge platform with extensive infrastructure intended to make things more
                                    convenient for our users.
                                </p>
                            </div>
                            <div class="tab-pane" id="feature-tab-3">
                                <p>We always try to expand our technical capabilities and financial prowess with the help of latest and advanced fintech technologies to facilitate transactions.<br><br>

                                    <?php echo e($settings->site_name); ?> Bank envisions to widen our customer reach to people of different races, countries and continents.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="about-us-section ptb-100">
    <div class="container">
        <div class="row justify-content-between align-items-center">
            <div class="col-md-12 col-lg-12">
                <div class="video-promo-content mb-md-4 mb-lg-0">
                    <h2 class="text-center">A brief history about us</h2>
                    <p>Our company, "<?php echo e($settings->site_name); ?> Bank", was founded in 2012 by a group of socially-minded entrepreneurs who saw the need for accessible financial services for low-income individuals and small businesses. They believed that by providing small loans and other financial services to these underbanked populations, they could help to promote economic growth and reduce poverty in their community.<br><br>

                    In the early days, <?php echo e($settings->site_name); ?> Bank focused on providing small loans to micro-entrepreneurs in their local area. They quickly realized that there was a high demand for their services and decided to expand their operations by opening new branches in other cities.<br><br>

                    As the company grew, they started to offer a wider range of financial services, such as savings accounts, insurance, and money transfers. They also began to develop innovative new products, such as mobile banking services, to make it easier for their customers to access their services.<br><br>

                    In 2013, <?php echo e($settings->site_name); ?> Bank received an investment from a major venture capital firm, which allowed them to scale up their operations and expand into new markets. By 2015, <?php echo e($settings->site_name); ?> Bank had become one of the largest microfinance companies in the country, serving thousands of customers and providing millions of dollars in loans and other financial services.<br><br>

                    Throughout its history, <?php echo e($settings->site_name); ?> Bank has always been guided by its mission to empower the underbanked and promote economic growth. The company's impact can be seen in the many small businesses that have been able to grow and create jobs as a result of their services, and the many families who have been able to improve their standard of living. <?php echo e($settings->site_name); ?> Bank remains committed to its mission and to providing affordable financial services to underserved communities
                    </p>
                </div>
            </div>


        </div>
    </div>
</section>

<section class="feature-content-two ptb-100 gray-light-bg">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="section-heading text-center mb-5">
                    <h2>Why Us?</h2>
                    <p class="lead">
                        Here are some of the many features that define our uniqueness.
                    </p>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-6 col-lg-4">
                <div class="feature-feature-list p-4 text-center">
                    <span class="ti-wallet icon-sm d-block color-secondary mb-3"></span>
                    <h5 class="mb-2">Multiple Payment options</h5>
                    <p>We support multiple payment methods: Visa, MasterCard, bank transfer, cryptocurrency and lots more</p>
                </div>
            </div>
            <div class="col-md-6 col-lg-4">
                <div class="feature-feature-list p-4 text-center">
                    <span class="ti-world icon-sm d-block color-secondary mb-3"></span>
                    <h5 class="mb-2">World Coverage</h5>
                    <p>We provide services in 80% countries around all the globe located in various continents.</p>
                </div>
            </div>
            <div class="col-md-6 col-lg-4">
                <div class="feature-feature-list p-4 text-center">
                    <span class="ti-money icon-sm d-block color-secondary mb-3"></span>
                    <h5 class="mb-2">Incredible Transaction Fee</h5>
                    <p>Our transaction fees and rates are incredibly low for all customers and all market makers </p>
                </div>
            </div>
            <div class="col-md-6 col-lg-4">
                <div class="feature-feature-list p-4 text-center">
                    <span class="ti-key icon-sm d-block color-secondary mb-3"></span>
                    <h5 class="mb-2">Secured Transactions</h5>
                    <p>Your finance is secured with our advanced technologies that protect you against digital thefts and hacks.</p>
                </div>
            </div>
            <div class="col-md-6 col-lg-4">
                <div class="feature-feature-list p-4 text-center">
                    <span class="ti-lock icon-sm d-block color-secondary mb-3"></span>
                    <h5 class="mb-2">Strong Security</h5>
                    <p>We offer you an unbeatable protection against DDoS attacks with full data encryption for all your transactions.</p>
                </div>
            </div>
            <div class="col-md-6 col-lg-4">
                <div class="feature-feature-list p-4 text-center">
                    <span class="ti-headphone-alt icon-sm d-block color-secondary mb-3"></span>
                    <h5 class="mb-2">24/7 Support</h5>
                    <p>Our customer care service is available at all time to attend to you and also offer solutions to all your needs.</p>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- END SECTION TEAM -->

<!-- END SECTION FAQ -->
</div>


<div class="client-section gray-light-bg" style="padding: 10px 0px;">
    <div class="container">
        <!--clients logo start-->
        <div class="row align-items-center">
            <div class="col-md-12">
                <div class="owl-carousel owl-theme clients-carousel dot-indicator">
                    <div class="item single-client">
                        <img src="temp/custom/base/img/clients-logo-01.png" alt="client logo" class="client-img">
                    </div>
                    <div class="item single-client">
                        <img src="temp/custom/base/img/clients-logo-02.png" alt="client logo" class="client-img">
                    </div>
                    <div class="item single-client">
                        <img src="temp/custom/base/img/clients-logo-03.png" alt="client logo" class="client-img">
                    </div>
                    <div class="item single-client">
                        <img src="temp/custom/base/img/clients-logo-04.png" alt="client logo" class="client-img">
                    </div>
                    <div class="item single-client">
                        <img src="temp/custom/base/img/clients-logo-05.png" alt="client logo" class="client-img">
                    </div>
                    <div class="item single-client">
                        <img src="temp/custom/base/img/clients-logo-06.png" alt="client logo" class="client-img">
                    </div>
                    <div class="item single-client">
                        <img src="temp/custom/base/img/clients-logo-07.png" alt="client logo" class="client-img">
                    </div>
                    <div class="item single-client">
                        <img src="temp/custom/base/img/clients-logo-08.png" alt="client logo" class="client-img">
                    </div>
                </div>
            </div>
        </div>
        <!--clients logo end-->
    </div>
</div>






<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\chase\resources\views/home/about.blade.php ENDPATH**/ ?>